/*
 * Decompiled with CFR 0.152.
 */
package frc.util;

import frc.emul.util.Utils;
import frc.util.BytesArrayOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class Unzip {
    private static final boolean FAKE_EXTRACT = false;
    private static final boolean FULL_PATHS = false;
    private final byte[] BUFFER = new byte[1024];
    private final boolean verbose;
    private final File srcFile;
    private volatile boolean abort;
    private volatile boolean extracting;
    private IMonitor monitor;
    private ZipFile zipFile;

    public static final String unzip(File file, IManager iManager, IMonitor iMonitor, boolean bl) throws IOException {
        Unzip unzip = new Unzip(file, bl);
        unzip.setMonitor(iMonitor);
        return unzip.process(iManager);
    }

    public static final String unzip(File file, File file2, IMonitor iMonitor, boolean bl) throws IOException {
        Unzip unzip = new Unzip(file, bl);
        unzip.setMonitor(iMonitor);
        return unzip.process(file2);
    }

    public static final boolean extractFile(File file, final String string, final File file2, boolean bl) throws IOException {
        if (file2.isFile()) {
            file2.delete();
        }
        Unzip unzip = new Unzip(file, bl);
        unzip.process(new DefaultManager(null){

            protected File getTarget(ZipEntry zipEntry) {
                return this.isTargetSkipped(zipEntry) ? null : file2;
            }

            public boolean isTargetSkipped(ZipEntry zipEntry) {
                return !string.equals(zipEntry.getName());
            }
        });
        return file2.isFile();
    }

    public static final byte[] extractBytes(File file, final String string, boolean bl) throws IOException {
        final BytesArrayOutputStream[] bytesArrayOutputStreamArray = new BytesArrayOutputStream[1];
        Unzip unzip = new Unzip(file, bl);
        try {
            unzip.process(new DefaultManager(null){

                public String getTargetPath(ZipEntry zipEntry, boolean bl) {
                    return zipEntry.getName();
                }

                public boolean isTargetSkipped(ZipEntry zipEntry) {
                    return zipEntry.isDirectory() || !string.equals(zipEntry.getName());
                }

                public OutputStream createTarget(ZipEntry zipEntry) {
                    bytesArrayOutputStreamArray[0] = new BytesArrayOutputStream((int)zipEntry.getSize());
                    return bytesArrayOutputStreamArray[0];
                }
            });
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException(String.valueOf(iOException.getMessage()) + " [" + file.getPath() + "]");
            iOException2.setStackTrace(iOException.getStackTrace());
            throw iOException2;
        }
        if (bytesArrayOutputStreamArray[0] == null) {
            throw new ZipException("No entry named [" + string + "] found in ZIP file [" + Utils.getAbsolutePath(file) + "]");
        }
        return bytesArrayOutputStreamArray[0].getCurrentContent();
    }

    public Unzip(File file, boolean bl) {
        this.srcFile = file;
        this.verbose = bl;
    }

    public void setMonitor(IMonitor iMonitor) {
        this.monitor = iMonitor;
    }

    public synchronized void abort() {
        this.abort = true;
        if (!this.extracting && this.monitor != null) {
            this.monitor.aborted();
        }
    }

    public final String process(File file) throws IOException {
        try {
            return this.process(new DefaultManager(file));
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException(String.valueOf(iOException.getMessage()) + " [" + file.getPath() + "]");
            iOException2.setStackTrace(iOException.getStackTrace());
            throw iOException2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String process(IManager iManager) throws IOException {
        Object object;
        this.extracting = true;
        this.prepare();
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements() && !this.abort) {
            object = enumeration.nextElement();
            if (iManager.isTargetSkipped((ZipEntry)object)) {
                if (this.verbose) {
                    System.out.println("   Skipping Entry : " + ((ZipEntry)object).getName());
                }
                if (this.monitor == null) continue;
                this.monitor.skipped((ZipEntry)object);
                continue;
            }
            if (((ZipEntry)object).isDirectory()) {
                if (!iManager.isTargetCreated((ZipEntry)object)) {
                    if (this.verbose) {
                        System.out.println("   Creating Folder : " + iManager.getTargetPath((ZipEntry)object, false));
                    }
                    iManager.createTarget((ZipEntry)object);
                    if (!iManager.isTargetCreated((ZipEntry)object)) {
                        return "Failed to create directory : " + iManager.getTargetPath((ZipEntry)object, true);
                    }
                }
            } else {
                InputStream inputStream;
                if (this.verbose) {
                    System.out.println("   Extracting File : " + iManager.getTargetPath((ZipEntry)object, false));
                }
                if ((inputStream = this.zipFile.getInputStream((ZipEntry)object)) != null) {
                    this.copyInputStream(inputStream, iManager, (ZipEntry)object);
                    if (!iManager.isTargetCreated((ZipEntry)object)) {
                        return "Failed to create file : " + iManager.getTargetPath((ZipEntry)object, true);
                    }
                } else {
                    System.out.println("** Failed to read zipped file : " + ((ZipEntry)object).getName());
                }
            }
            if (this.monitor == null) continue;
            this.monitor.extracted((ZipEntry)object);
        }
        this.zipFile.close();
        object = this;
        synchronized (object) {
            if (this.monitor != null) {
                if (this.abort) {
                    this.monitor.aborted();
                } else {
                    this.monitor.completed();
                }
            }
            this.extracting = false;
        }
        return this.abort ? "The operation has been aborted." : null;
    }

    public final void copyFile(File file, File file2) throws IOException {
        this.copyInputStream((InputStream)new FileInputStream(file), file2);
    }

    private void prepare() throws IOException {
        this.zipFile = new ZipFile(this.srcFile);
        if (this.monitor != null) {
            int n = 0;
            int n2 = 0;
            Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
            while (enumeration.hasMoreElements()) {
                if (enumeration.nextElement().isDirectory()) {
                    ++n;
                    continue;
                }
                ++n2;
            }
            this.monitor.setZipInfo(n2, n);
        }
    }

    private final void copyInputStream(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            this.copyInputStream(inputStream, fileOutputStream);
        }
        finally {
            inputStream.close();
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
    }

    private final void copyInputStream(InputStream inputStream, IManager iManager, ZipEntry zipEntry) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = iManager.createTarget(zipEntry);
            this.copyInputStream(inputStream, outputStream);
        }
        finally {
            inputStream.close();
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private final void copyInputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            if (outputStream != null) {
                int n;
                outputStream = new BufferedOutputStream(outputStream);
                while ((n = inputStream.read(this.BUFFER)) >= 0) {
                    outputStream.write(this.BUFFER, 0, n);
                }
            }
        }
        finally {
            inputStream.close();
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private static final String getPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getPath();
        }
    }

    public static class DefaultManager
    implements IManager {
        protected final File destDir;

        public DefaultManager(File file) {
            this.destDir = file;
        }

        protected File getTarget(ZipEntry zipEntry) {
            return new File(this.destDir, zipEntry.getName());
        }

        public String getTargetPath(ZipEntry zipEntry, boolean bl) {
            File file = this.getTarget(zipEntry);
            return file == null ? zipEntry.getName() : (bl ? Unzip.getPath(file) : zipEntry.getName());
        }

        public boolean isTargetSkipped(ZipEntry zipEntry) {
            return false;
        }

        public boolean isTargetCreated(ZipEntry zipEntry) throws IOException {
            File file = this.getTarget(zipEntry);
            return file != null && (zipEntry.isDirectory() ? file.isDirectory() : file.isFile());
        }

        public OutputStream createTarget(ZipEntry zipEntry) throws IOException {
            File file = this.getTarget(zipEntry);
            if (file == null) {
                return null;
            }
            if (zipEntry.isDirectory()) {
                file.mkdirs();
                return null;
            }
            file.getParentFile().mkdirs();
            return new FileOutputStream(file);
        }
    }

    public static interface IManager {
        public String getTargetPath(ZipEntry var1, boolean var2);

        public boolean isTargetSkipped(ZipEntry var1);

        public boolean isTargetCreated(ZipEntry var1) throws IOException;

        public OutputStream createTarget(ZipEntry var1) throws IOException;
    }

    public static interface IMonitor {
        public void setZipInfo(int var1, int var2);

        public void skipped(ZipEntry var1);

        public void extracted(ZipEntry var1);

        public void completed();

        public void aborted();
    }
}

